// CompteDeBanque.cpp: implementation of the CCompteDeBanque class.
//
//////////////////////////////////////////////////////////////////////
#include <iostream>
#include <string>
using namespace std;
#include "CompteDeBanque.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCompteDeBanque::CCompteDeBanque()
{

}

CCompteDeBanque::CCompteDeBanque(long lInit, string sInit)
{
	lNumero       = lInit;
	sProprietaire = sInit;
	dSolde        = 0;
}

CCompteDeBanque::~CCompteDeBanque()
{

}

double CCompteDeBanque::Retirer(double dMontant)
{
	double dMontantRetire;

	if (dSolde >= dMontant)
	{
		dMontantRetire = dMontant;
		dSolde -= dMontant;
	}
	else
	{
		dMontantRetire = dSolde;
		dSolde = 0;
	}

	cout << sProprietaire << " a retire " << dMontantRetire << "$" << endl;

	return dMontantRetire;
}

void CCompteDeBanque::Deposer(double dMontant)
{
	dSolde += dMontant;

	cout << sProprietaire << " a depose " << dMontant << "$" << endl;
}

void CCompteDeBanque::ImprimerInformation()
{
	cout.width(80);
	cout.fill('=');
	cout << "[Informations sur le compte]" << endl;

	cout << "Numero:       "
		 << lNumero
		 << endl;

	cout << "Proprietaire: " 
		 << sProprietaire
		 << endl;

	cout << "Solde:        "
		 << dSolde
		 << endl;

	cout.width(80);
	cout.fill('=');
	cout << endl << "" << endl;
}

void CCompteDeBanque::Bonus(unsigned short valeur)
{
	for (valeur; valeur >= 0; valeur--)
	{
		dSolde++;
	}
}
