#ifndef ECRAN_H
#define ECRAN_H
// Le nombre de rangee maximale et de colonne maximale
const int MAX_RANGEE_BAS = 24;
const int MAX_COLONNE_BAS = 79;
const int MAX_COLONNE_HAUT = 79;
const int MAX_RANGEE_HAUT = 11; // Celle qui separe les 2 portions d'ecran

// Les attributs des caracteres
typedef enum
{
   AUCUN,HI,LOW,ITALIQUE,SOULIGNE,BLINK,RAPBLINK,REVVIDEO,INVISIBLE
}
attr;

// La partie haute ou basse de l'ecran
typedef enum
{
   PARTIE_HAUTE_ECRAN, PARTIE_BASSE_ECRAN
}
DivisionEcran;

// Les fonctions ecrites en assembleur
extern "C"
{
   void Ecrire_Ecran (char c, int pos);
   void Ecran_Ecrire_XYattr (char c, attr attribut, int r, int col);
   void Ecran_Ecrire_XY (char c, int rang, int col);
   void Ecran_Efface();
   char Ecran_Lire_Caractere_XY(int rang, int col);
}

// Les fonctions a ecrire par l'eleve
void Ecran_Ecrire(char c, int Rangee, int Colonne);
// Cette fonction permet d'ecrire un caractere a la rangee et a
// la colonne specifiee.

void Ecran_Deroule(DivisionEcran);
// Cette fonction deroule "scroll" l'ecran du haut d'une ligne vers
// le haut lorsque la rangee est 11 et la colonne est a 79.
// Cette fonction deroule l'ecran du bas lorsque la rangee est 24 et
// la colonne vaut 79.
// Le deroulement dans l'ecran du haut ou du bas est specifie par la
// variable de type DivisionEcran

void Ecran_Initialise();
// Cette fonction initialise l'ecran.  On vide l'ecran et on y affiche
// une ligne separatrice au millieu de ce dernier.

void Message();
// Fonction sert tout simplement a faire afficher le message
// "Esc pour terminer. Je n'ecris rien ici..." dans l'ecran du bas.

void Ecran_Echo(char c, int &RangeeHautEcran, int &ColonneHautEcran);
// Fonction sert a afficher a l'ecran un caractere avec le deroulement
// de lignes et autres bebelles

#endif
