#ifndef SERIE_H
#define SERIE_H

// Interruption BIOS 14h pour gerer le port serie
const int 	SERIE = 0X14;

// Les choix possibles de ports serie
const int	COM1 = 0
,	  	COM2 = 1
;

// Les choix de vitesse de transmission possibles
const int 	BAUD1200 = 0x04
,      		BAUD2400 = 0x05
,		BAUD4800 = 0x06
,		BAUD9600 = 0x07
;

// Les choix de parite possibles
const	int	ODD = 0x01
,		EVEN = 0x02
;
// Les fonctions d'entree/sortie a utiliser
const int 	FCT_PORT_SERIE_INIT   = 0
,         	FCT_PORT_SERIE_ECRIRE_CAR = 1
,         	FCT_PORT_SERIE_LIRE_CAR = 2
,	  	FCT_PORT_SERIE_STATUT = 3
;
const char ACK = 0;

// Fonction: unsigned short Port_Serie ()
// Demade le numero du port serie a utiliser
// Retourne la valeur qui represente le numero du port
unsigned short Port_Serie();

// Fonction: unsigned char Port_Serie_Config ()
// Demade des parametres d'initialisation du port serie
// Retourne l'octet qui represente les parametres d'initialisation
unsigned char Port_Serie_Config();

// Fonction: Port_Serie_Init (unsigned char Config, unsigned short Port)
// Initialise le port serie
// a l'aide de la fonction FCT_PORT_SERIE_INIT de
// l'interrupt 14h de BIOS. Retourne vrai si le port
// est initialise correctement et faux sinon.
bool Port_Serie_Init (unsigned char Config, unsigned short Port);

// Fonction: Port_Serie_Ecrire_Car (char Car, unsigned short Port)
// Envoie un caractere passe en parametre sur le port serie
// a l'aide de la fonction FCT_PORT_SERIE_ECRIRE_CAR de l'interrupt 14h
// Retourne true si l'ecriture s'est bien deroulee
// et false sinon
bool Port_Serie_Ecrire_Car (char Car, unsigned short Port);

// Fonction: Port_Serie_Lire_Car (unsigned short Port)
// Lit un caractere sur le port serie
// a l'aide de la fonction FCT_PORT_SERIE_LIRE_CAR de l'interrupt 14h
// Retourne le caractere lu
char Port_Serie_Lire_Car (unsigned short Port);

// Fonction: Port_Serie_Statut (unsigned short Port)
// Test s'il y a un caractere recu sur le port serie
// a l'aide de la fonction FCT_PORT_SERIE_STATUT de l'interrupt 14h
// Retourne true s'il y a un caractere sur le port serie et
// false sinon
bool Port_Serie_Statut (unsigned short Port);

#endif // !defined SERIE_H