Attribute VB_Name = "modSurfaces"
Option Explicit

' Les index de surfaces vont de 0  2^7-2 inclusivement. La
' surface 2^7-1 est rserve pour les surfaces nulles
' (l o il n'y a rien  afficher, comme par exemple
' lorsqu"on est  l'extrieur de la carte)
Private Const MIN_SURFACES As Integer = 0
Private Const SURFACE_NULLE As Integer = 2 ^ 7 - 1 ' 127
' N'inclut que les surfaxces dites valides
Private Const MAX_SURFACES As Integer = SURFACE_NULLE ' 127

' On se rserve la place suffisante
Private TabSurfaces(MIN_SURFACES To MAX_SURFACES + 1) As Picture

' La procdure InitSurfaces() ne doit tre appele
' qu'une seule fois, au chargement du programme
'
' Exemple d'utilisation:
'
' InitSurfaces
Public Sub InitSurfaces()
    ' Le rpertoire des surfaces est prsum comme se
    ' nommant Surfaces, dans le rpertoire de travail
    ' du projet, et chaque surface est prsume comme
    ' se nommant pi suivi de son index et de son
    ' extension, .bmp (exemple: pi0.bmp)
    Const IMG_RPERTOIRE As String = "Surfaces\"
    Const IMG_PRFIXE As String = "pi"
    Const IMG_EXTENSION As String = ".bmp"
    Dim ImgRpertoire As String
    
    Dim i As Integer

    ' Construire le rpertoire des images
    ImgRpertoire = App.Path
    If Right(ImgRpertoire, 1) <> "\" Then
        ImgRpertoire = ImgRpertoire & "\"
    End If
    ImgRpertoire = ImgRpertoire & IMG_RPERTOIRE

    ' On remplit tout sauf la MAX_SURFACES-ime
    ' (qui doit contenir l'image nulle)
    For i = MIN_SURFACES To MAX_SURFACES - 1
        Set TabSurfaces(i) = LoadPicture(ImgRpertoire & _
                                         IMG_PRFIXE & _
                                         CStr(i) & _
                                         IMG_EXTENSION)
    Next i
    ' L'image nulle s'obtient par un LoadPicture
    ' d'un fichier identifi par une chane vide
    Set TabSurfaces(SURFACE_NULLE) = LoadPicture("")
End Sub

' Fonction qui retourne VRAI si l'index pass en
' paramtre est un index de surface valide (dans
' les bornes) et FAUX sinon.
'
' Exemple d'utilisation:
'
' If IndexSurfaceValide (indexDeSurface) Then
Public Function IndexSurfaceValide(Index As Integer) As Boolean
    IndexSurfaceValide = (Index >= MIN_SURFACES And Index <= MAX_SURFACES)
End Function

' Fonction qui retourne l'image  l'index spcifi
' en paramtre si cet index est valide, ou la surface
' nulle sinon.
'
' Exemple d'utilisation:
'
' Set imgMonImage(i).Picture = GetSurface (indexDeSurface)
Public Function GetSurface(Index As Integer) As Picture
    If IndexSurfaceValide(Index) Then
        Set GetSurface = TabSurfaces(Index)
    Else
        Set GetSurface = TabSurfaces(SURFACE_NULLE)
    End If
End Function
