Attribute VB_Name = "POQEDEXDB"
Option Explicit

Const MAX_POQMON As Byte = 6
Const RQPOQINDEX As Byte = 0
Const RQPOQINFO As Byte = 1
Const RQPOQSTATUS As Byte = 2

Public Const STR_RQPOQINDEX As String = "RQPOQINDEX"
Public Const STR_RQPOQINFO As String = "RQPOQINFO"
Public Const STR_RQPOQSTATUS As String = "RQPOQSTATUS"

Private T_POQdex(MAX_POQMON) As String
Private Coll_POQdex As New Collection
Private Str_RQStatus As String

Public Sub Connecter()
    Randomize
    Lire_Fichier
    Str_RQStatus = ""
End Sub

Public Sub Envoyer(Chane As String)
    Dim Position As Integer
    Dim Dpart As Integer
    Dim StrInfo As String
    Dim Requte As Byte
    Dim Identification As Integer
    Dim POQIndex As Byte
    
    Position = InStr(Chane, ";")
    Requte = Identifier_Requte(Mid(Chane, 1, Position - 1))
    Dpart = Position + 1
    Position = InStr(Dpart, Chane, ";")
    Identification = CInt(Mid(Chane, Dpart, Position - Dpart))
    If Requte = RQPOQINDEX Then
        Set_RQPOQINDEX Identification
    ElseIf Requte = RQPOQINFO Then
        POQIndex = CByte(Mid(Chane, Position + 1, Len(Chane) - Position - 2))
        Set_RQPOQINFO Identification, POQIndex
    Else
        Set_RQPOQSTATUS Identification
    End If
End Sub

Public Sub Recevoir(Chane As String)
    Chane = Get_RQPOQ
End Sub

Private Sub Lire_Fichier()
    Dim Systme_De_Fichier As Object
    Dim Fichier As Object
    Dim Nom_Du_Fichier As String
    Dim Chane As String
    Dim Idx As Integer
    
    Nom_Du_Fichier = "POQEMONBD.TXT"
    If Right(App.Path, 1) = "\" Then
        Nom_Du_Fichier = App.Path & Nom_Du_Fichier
    Else
        Nom_Du_Fichier = App.Path & "\" & Nom_Du_Fichier
    End If
    Set Systme_De_Fichier = CreateObject("Scripting.FileSystemObject")
    Set Fichier = Systme_De_Fichier.OpenTextFile(Nom_Du_Fichier, 1)
    Idx = 0
    Chane = "Aucun POQmon dtect !"
    Do While Len(Chane) > 0
        T_POQdex(Idx) = Chane
        Chane = Fichier.readline
        Idx = Idx + 1
    Loop
    Fichier.Close
End Sub

Private Function Identifier_Requte(Chane As String) As Byte
    Select Case UCase(Chane)
        Case STR_RQPOQINDEX
            Identifier_Requte = RQPOQINDEX
        Case STR_RQPOQINFO
            Identifier_Requte = RQPOQINFO
    End Select
End Function

Private Sub Set_RQPOQINDEX(Id As Integer)
    On Error GoTo Gestion_des_erreurs
    Dim POQIndex As Byte
    
    POQIndex = Int(MAX_POQMON * Rnd)
    Coll_POQdex.Add "REP;" & Id & ";" & POQIndex & ";;"
    On Error GoTo 0
    Exit Sub
Gestion_des_erreurs:
    Str_RQStatus = "RQ = RQPOQINDEX - ID = " & Id & " - Erreur #" & CStr(Err.Number) & " -  Description = " & Err.Description
    On Error GoTo 0
End Sub

Private Sub Set_RQPOQINFO(Id As Integer, Idx As Byte)
    On Error GoTo Gestion_des_erreurs
    Dim POQInfo As String
    
    POQInfo = T_POQdex(Idx)
    Coll_POQdex.Add "REP;" & Id & ";" & POQInfo & ";;"
    On Error GoTo 0
    Exit Sub
Gestion_des_erreurs:
    Str_RQStatus = "RQ = RQPOQINFO - ID = " & Id & " - Erreur #" & CStr(Err.Number) & " -  Description = " & Err.Description
    On Error GoTo 0
End Sub

Private Sub Set_RQPOQSTATUS(Id As Integer)
    On Error GoTo Gestion_des_erreurs
    Coll_POQdex.Add Str_RQStatus
    On Error GoTo 0
    Exit Sub
Gestion_des_erreurs:
    Str_RQStatus = "RQ = RQSTATUS - ID = " & Id & " - Erreur #" & CStr(Err.Number) & " -  Description = " & Err.Description
    On Error GoTo 0
End Sub

Private Function Get_RQPOQ() As String
    On Error GoTo Gestion_des_erreurs
    Get_RQPOQ = Coll_POQdex.Item(1)
    Coll_POQdex.Remove 1
    On Error GoTo 0
    Exit Function
Gestion_des_erreurs:
    Str_RQStatus = "RQ = RQPOQ - Erreur #" & CStr(Err.Number) & " -  Description = " & Err.Description
    On Error GoTo 0
End Function


