VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Cls_RQ_Manager"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"

'Auteur : Vincent Echelard

Option Explicit

Private Const FIN_RQ As String = ";;"

Private No_ID As New Cls_No_ID
Private Coll_RQ_Batch__Envoyer As New Coll_Requtes
Private Coll_RQ_Squentielles__Envoyer As New Coll_Requtes
Private Coll_RQ_Batch_Envoyes As New Coll_Requtes
Private Coll_RQ_Squentielles_Envoyes As New Coll_Requtes
'

Public Function Combien_de_requte__envoyer(RQSquentielle As Boolean)
    Dim Nb_RQ As Integer
    
    If RQSquentielle Then
        Nb_RQ = Coll_RQ_Squentielles__Envoyer.Count
    Else
        Nb_RQ = Coll_RQ_Batch__Envoyer.Count
    End If
    Combien_de_requte__envoyer = Nb_RQ
End Function

Public Sub Composer_Requte(RQSquentielle As Boolean, _
                             Type_RQ As String, _
                             Optional Info As Variant)
    Dim No_ID_RQ As Integer
    Dim Str_Requte As String
    
    No_ID_RQ = No_ID.Prochain_No_ID
    If IsMissing(Info) Then
        Str_Requte = Type_RQ & RQ_SPARATEUR & CStr(No_ID_RQ) & FIN_RQ
    Else
        Str_Requte = Type_RQ & RQ_SPARATEUR & CStr(No_ID_RQ) & _
                      RQ_SPARATEUR & Info & FIN_RQ
    End If
    
    If RQSquentielle Then
        Coll_RQ_Squentielles__Envoyer.Add No_ID_RQ, Type_RQ, Str_Requte
    Else
        Coll_RQ_Batch__Envoyer.Add No_ID_RQ, Type_RQ, Str_Requte
    End If
End Sub

Private Sub Envoyer_les_requtes_Batch()
    Dim obj_Requte As Cls_Requte
    Dim Str_Communication As String
    Dim toto

    For Each obj_Requte In Coll_RQ_Batch__Envoyer
        Str_Communication = obj_Requte.Str_Requte
        Envoyer Str_Communication
        'MsgBox Str_Communication
        With obj_Requte
            Coll_RQ_Batch_Envoyes.Add .No_ID, .Type_Requte, .Str_Requte
            Coll_RQ_Batch__Envoyer.Remove CStr(.No_ID)
        End With
    Next
End Sub

Private Sub Envoyer_une_requte_Squentielle()
    Dim obj_Requte As Cls_Requte
    Dim obj_Requte2 As Cls_Requte
    Dim Str_Communication As String

    If Coll_RQ_Squentielles_Envoyes.Count = 0 And _
        Coll_RQ_Squentielles__Envoyer.Count > 0 Then
        Set obj_Requte = Coll_RQ_Squentielles__Envoyer.Item(1)
        Str_Communication = obj_Requte.Str_Requte
        Envoyer Str_Communication
        'MsgBox Str_Communication
        With obj_Requte
            Coll_RQ_Squentielles_Envoyes.Add .No_ID, .Type_Requte, .Str_Requte
            Coll_RQ_Squentielles__Envoyer.Remove CStr(.No_ID)
        End With
    End If
End Sub

Public Sub Envoyer_Requtes_Client()
    Envoyer_les_requtes_Batch
    Envoyer_une_requte_Squentielle
End Sub

Private Sub Extraire_la_requte_initiale(Str_Rponse As String, obj_Requte As Cls_Requte)
    ' On prend en charge la gestion des erreurs en remplaant le traitement
    ' Standard des erreurs par un traitement priv !
    Dim No_ID_de_la_Rponse As String
    Dim Position_Initiale As Integer
    Dim Position_Finale As Integer
    
    ' On extrait le # d'identification de la rponse
    Position_Initiale = InStr(1, Str_Rponse, RQ_SPARATEUR) + 1
    Position_Finale = InStr(Position_Initiale, Str_Rponse, RQ_SPARATEUR)
    No_ID_de_la_Rponse = Mid(Str_Rponse, Position_Initiale, Position_Finale - Position_Initiale)
    ' On tente d'extraire la requte de la collection Coll_RQ_Batch_Envoyes
    Set obj_Requte = Coll_RQ_Batch_Envoyes.Item(No_ID_de_la_Rponse)
    If obj_Requte Is Nothing Then 'Item nous retourne Nothing (donc pas dans la collection)
        Set obj_Requte = Coll_RQ_Squentielles_Envoyes.Item(No_ID_de_la_Rponse)
        Coll_RQ_Squentielles_Envoyes.Remove No_ID_de_la_Rponse
    Else
        Coll_RQ_Batch_Envoyes.Remove No_ID_de_la_Rponse
    End If
End Sub


Public Sub Recevoir_Rponses_Serveur()
    Dim Str_Communication As String * 1024
    Dim obj_Requte As Cls_Requte
    
    Do While GetNbReponsesPretes() > 0
        Recevoir Str_Communication
        Extraire_la_requte_initiale Str_Communication, obj_Requte
        Traiter_la_Rponse Str_Communication, obj_Requte
    Loop
End Sub
