VERSION 5.00
Begin VB.Form Dlg_Choix_du_Dresseur 
   BackColor       =   &H80000005&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Choix du dresseur"
   ClientHeight    =   2010
   ClientLeft      =   2760
   ClientTop       =   3750
   ClientWidth     =   6120
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2010
   ScaleWidth      =   6120
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox Txt_Surnom 
      BeginProperty Font 
         Name            =   "Comic Sans MS"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   3
      Text            =   "Toto"
      Top             =   600
      Width           =   4455
   End
   Begin VB.ComboBox Cbo_Choix_Dresseur 
      Height          =   315
      Left            =   120
      TabIndex        =   2
      Top             =   1680
      Width           =   4455
   End
   Begin VB.CommandButton Cmd_Annuler 
      BackColor       =   &H80000004&
      Cancel          =   -1  'True
      Caption         =   "Annuler"
      Height          =   375
      Left            =   4800
      Style           =   1  'Graphical
      TabIndex        =   1
      Top             =   600
      Width           =   1215
   End
   Begin VB.CommandButton Cmd_OK 
      BackColor       =   &H80000004&
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   4800
      Style           =   1  'Graphical
      TabIndex        =   0
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label Lbl_Liste_Dresseurs 
      BackColor       =   &H80000005&
      Caption         =   "Liste des dresseurs disponibles"
      BeginProperty Font 
         Name            =   "Comic Sans MS"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   5
      Top             =   1200
      Width           =   4455
   End
   Begin VB.Label Lbl_Surnom 
      BackColor       =   &H80000005&
      Caption         =   "Votre surnom"
      BeginProperty Font 
         Name            =   "Comic Sans MS"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   4
      Top             =   120
      Width           =   4455
   End
End
Attribute VB_Name = "Dlg_Choix_du_Dresseur"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'Auteur : Vincent Echelard

'description: Cette form permet de grer le choix du dresseur.

Option Explicit

'Private Sub Cmd_Annuler_Click
'description: Appeler si l'utilisateur clique sur le bouton Annuler ou
'             tape la touche <ESC>.
'             Met l'index du dresseur demand  zro pour que le serveur en
'             attribue un au hasard.
'             Le surnom du dresseur reste celui par dfaut (Toto).
Private Sub Cmd_Annuler_Click()
    Obj_Personnage.IndexDresseur = 0
    Unload Me
End Sub

'Private Sub Cmd_OK_Click
'description: Appeler si l'utilisateur clique sur le bouton Ok ou
'             tape la touche <RETURN>.
'             Le surnom du dresseur devient celui entr par l'utilisateur.
'             Met l'index du dresseur demand  la valeur qui correspond au nom
'             du dresseur slectionn.
Private Sub Cmd_OK_Click()
    With Obj_Personnage
        .Surnom = Trim(Txt_Surnom.Text) 'La fonction Trim permet d'liminer les espaces
                                        'au dbut et  la fin de la chane de caractres
        .IndexDresseur = Coll_Dresseurs.Item(Cbo_Choix_Dresseur.Text).IndexDresseur
    End With
    Unload Me
End Sub

'Private Sub Form_Load
'description: Appeler si l'utilisateur lors du chargement de la form.
'             Initialise le textbox servant  la saisie du surnom  la valeur par dfaut.
'             Charge le combobox  partir de la collection contenant les dresseurs
'             disponibles.
Private Sub Form_Load()
    Dim obj_DresseurTmp As Cls_Dresseur
    
    Txt_Surnom.Text = Obj_Personnage.Surnom
    Cbo_Choix_Dresseur.Clear
    For Each obj_DresseurTmp In Coll_Dresseurs
        Cbo_Choix_Dresseur.AddItem obj_DresseurTmp.Nom
    Next
    Cbo_Choix_Dresseur.Text = Cbo_Choix_Dresseur.List(0) 'slectionne le premier dresseur
End Sub

'Private Sub Txt_Surnom_Change
'description: Appeler si l'utilisateur modifie le contenu du textbox du surnom.
'             Si l'utilisateur a entr autre chose que des espaces, le bouton Ok
'             devient actif (enabled = true) sinon il devient inactif (enabled = false)
'             Cette Sub utilise la fonction Len qui retourne la longueur de la chane et
'             la fonction Trim qui retire les espaces superflus.
Private Sub Txt_Surnom_Change()
    Cmd_OK.Enabled = Len(Trim(Txt_Surnom.Text)) > 0
End Sub
