Attribute VB_Name = "Mod_POQespace"

'Auteur : Vincent Echelard

Option Explicit

Private Const NORD As String = "N"
Private Const SUD As String = "S"
Private Const EST As String = "E"
Private Const OUEST As String = "O"

Private Const CASE_CENTRALE As Integer = 12

Private Const IMAGE_AUTRE_DRESSEUR As String = "misty"
Private Const IMAGE_BOUSSOLE_EST As String = "Boussole_EST"
Private Const IMAGE_BOUSSOLE_OUEST As String = "Boussole_OUEST"
Private Const IMAGE_BOUSSOLE_SUD As String = "Boussole_SUD"
Private Const IMAGE_BOUSSOLE_NORD As String = "Boussole_NORD"
Private Const IMAGE_JOUEUR As String = "ash"
Private Const IMAGE_OBJET As String = "pokeball"
Private Const IMAGE_POQMON As String = "pokemon"
Private Const IMAGE_SURFACE As String = "pi"
Private Const MAX_CASES As Integer = 25

Private T_Cases_Tangible(0 To MAX_CASES - 1) As Boolean
'

Private Sub Afficher_Boussole()
    With Frm_POQespace.Img_Boussole
        Select Case Obj_Personnage.Direction
            Case EST
                Set .Picture = Coll_Images.Item(IMAGE_BOUSSOLE_EST)
            Case NORD
                Set .Picture = Coll_Images.Item(IMAGE_BOUSSOLE_NORD)
            Case OUEST
                Set .Picture = Coll_Images.Item(IMAGE_BOUSSOLE_OUEST)
            Case SUD
                Set .Picture = Coll_Images.Item(IMAGE_BOUSSOLE_SUD)
        End Select
    End With
End Sub

Private Sub Afficher_Grille()
    Dim Zone As Cls_Zone
    Dim Ind_zone As Integer
    
    Ind_zone = 0
    With Frm_POQespace
        For Each Zone In Coll_Zones
            T_Cases_Tangible(Ind_zone) = Zone.Tangible
            .Img_Surface(Ind_zone).Picture = Coll_Images.Item(IMAGE_SURFACE & Zone.Surface)
            If Zone.Objet Then
                .Img_Objet(Ind_zone).Picture = Coll_Images.Item(IMAGE_OBJET)
            Else
                .Img_Objet(Ind_zone).Picture = Coll_Images.Item(IMAGE_VIDE)
            End If
            If Zone.POQmon Then
                .Img_POQmon(Ind_zone).Picture = Coll_Images.Item(IMAGE_POQMON)
            Else
                .Img_POQmon(Ind_zone).Picture = Coll_Images.Item(IMAGE_VIDE)
            End If
            If Zone.Dresseur Then
                If Ind_zone = CASE_CENTRALE Then
                    .Img_Dresseur(Ind_zone).Picture = Coll_Images.Item(IMAGE_JOUEUR)
                Else
                    .Img_Dresseur(Ind_zone).Picture = Coll_Images.Item(IMAGE_AUTRE_DRESSEUR)
                End If
            Else
                .Img_Dresseur(Ind_zone).Picture = Coll_Images.Item(IMAGE_VIDE)
            End If
            Ind_zone = Ind_zone + 1
            Coll_Zones.Remove 1
        Next
    End With
End Sub

Private Sub CrerGrille(Ctrl_Image As Object, Delta As Long)
    Dim i As Integer
    Dim X As Integer
    Dim Y As Integer
    
    For i = 1 To 24
        X = i Mod 5
        Y = i \ 5
        Load Ctrl_Image(i)
        Ctrl_Image(i).Left = Ctrl_Image(i).Left + Delta * X
        Ctrl_Image(i).Top = Ctrl_Image(i).Top + Delta * Y
        Ctrl_Image(i).Visible = True
        Ctrl_Image(i).ZOrder
    Next
End Sub

Public Sub Grer_Affichage()
    If Grille_Affiche_est_modifie Then
        Afficher_Grille
        Vrifier_Si_Les_Boutons_Doivent_tre_Actif
        Grille_Affiche_est_modifie = False
    End If
    If Boussole_est_modife Then
        Afficher_Boussole
        Vrifier_Si_Les_Boutons_Doivent_tre_Actif
        Boussole_est_modife = False
    End If
End Sub

Public Sub Initialiser_Affichage()
    With Frm_POQespace
        CrerGrille .Img_Surface, .Img_Surface(0).Width
        CrerGrille .Img_Objet, .Img_Surface(0).Width
        CrerGrille .Img_Dresseur, .Img_Surface(0).Width
        CrerGrille .Img_POQmon, .Img_Surface(0).Width
    End With
End Sub

Public Sub Quitter()
    End
End Sub

Public Sub Vrifier_Si_Les_Boutons_Doivent_tre_Actif()
    Dim BtnAvancer As Boolean
    Dim BtnReculer As Boolean
    
    With Frm_POQespace
        Select Case Obj_Personnage.Direction
            Case EST
                BtnAvancer = Not T_Cases_Tangible(CASE_CENTRALE + 1)
                BtnReculer = Not T_Cases_Tangible(CASE_CENTRALE - 1)
            Case NORD
                BtnAvancer = Not T_Cases_Tangible(CASE_CENTRALE - 5)
                BtnReculer = Not T_Cases_Tangible(CASE_CENTRALE + 5)
            Case OUEST
                BtnAvancer = Not T_Cases_Tangible(CASE_CENTRALE - 1)
                BtnReculer = Not T_Cases_Tangible(CASE_CENTRALE + 1)
            Case SUD
                BtnAvancer = Not T_Cases_Tangible(CASE_CENTRALE + 5)
                BtnReculer = Not T_Cases_Tangible(CASE_CENTRALE - 5)
        End Select
        .Cmd_Avancer.Enabled = BtnAvancer
        .Cmd_Reculer.Enabled = BtnReculer
    End With
End Sub
