Attribute VB_Name = "Mod_RQ_Rception"

'Auteur : Vincent Echelard

Option Explicit
'
Public Sub Crer_la_Liste_des_Dresseurs(Coll_Rponses As Collection)
    Dim Nb_lments As Integer
    Dim Index_Coll As Integer
    
    Index_Coll = 3 ' On saute les deux premiers lments de la rponse (REP et Id)
    Nb_lments = Coll_Rponses.Count
    Do While Index_Coll <= Nb_lments
        Dim obj_dresseur As New Cls_Dresseur
        
        obj_dresseur.Nom = Coll_Rponses.Item(Index_Coll)
        obj_dresseur.IndexDresseur = Coll_Rponses.Item(Index_Coll + 1)
        Index_Coll = Index_Coll + 2
        Coll_Dresseurs.Add obj_dresseur, obj_dresseur.Nom
        Set obj_dresseur = Nothing
    Loop
End Sub

Public Sub Crer_la_Liste_des_Zones(Coll_Rponses As Collection)
    Const SURFACE_TANGIBLE As Integer = 97
    Const SURFACE_NON_TANGIBLE As Integer = 0
    Const BIT_TANGIBLE As Integer = 7
    Const BIT_POQMON As Integer = 8
    Const BIT_DRESSEUR As Integer = 9
    Const BIT_OBJET As Integer = 10
    
    Dim Nb_lments As Integer
    Dim Index_Coll As Integer
    Dim Descripteur As Integer
    
    Index_Coll = 3 ' On saute les deux premiers lments de la rponse (REP et Id)
    Nb_lments = Coll_Rponses.Count
    Do While Index_Coll <= Nb_lments
        Dim obj_zone As New Cls_Zone
        
        Descripteur = CInt(Coll_Rponses.Item(Index_Coll))
        obj_zone.Dresseur = ((Descripteur And 2 ^ BIT_DRESSEUR) <> 0)
        obj_zone.Objet = ((Descripteur And 2 ^ BIT_OBJET) <> 0)
        obj_zone.POQmon = ((Descripteur And 2 ^ BIT_POQMON) <> 0)
        obj_zone.Tangible = ((Descripteur And 2 ^ BIT_TANGIBLE) <> 0)
        If obj_zone.Tangible Then
            obj_zone.Surface = SURFACE_TANGIBLE
        Else
            obj_zone.Surface = SURFACE_NON_TANGIBLE
        End If
        Index_Coll = Index_Coll + 1
        Coll_Zones.Add obj_zone
        Set obj_zone = Nothing
    Loop
End Sub

Private Sub Dcomposer_la_Rponse(str_Rep As String, Coll_jetons As Collection)
    Dim Position As Integer
    Dim Chane As String
    
    Chane = str_Rep
    Do While Left(Chane, 1) <> RQ_SPARATEUR
        Position = InStr(Chane, RQ_SPARATEUR)
        Coll_jetons.Add Mid(Chane, 1, Position - 1)
        Chane = Mid(Chane, Position + 1)
    Loop
End Sub



Public Sub Traiter_la_Rponse(Str_Rponse As String, obj_Requte As Cls_Requte)
    Dim Coll_lments_de_Rponse As New Collection
    
    Dcomposer_la_Rponse Str_Rponse, Coll_lments_de_Rponse
    Select Case obj_Requte.Type_Requte
        Case RQ_DEPLACEMENT
            Traiter_RQ_DEPLACEMENT Coll_lments_de_Rponse, obj_Requte
        Case RQ_JE_SUIS
            Traiter_RQ_JE_SUIS Coll_lments_de_Rponse
        Case RQ_LISTE_DRESSEURS
            Traiter_RQ_LISTE_DRESSEURS Coll_lments_de_Rponse
        Case RQ_MAP_INFO
            Traiter_RQ_MAP_INFO Coll_lments_de_Rponse
        Case RQ_OU_SUIS_JE
            Traiter_RQ_OU_SUIS_JE Coll_lments_de_Rponse
        Case RQ_POQ_INDEX
            Traiter_RQ_POQ_INDEX Coll_lments_de_Rponse
        Case RQ_POQ_INFO
            Traiter_RQ_POQ_INFO Coll_lments_de_Rponse
        Case RQ_POURQUOI
            Traiter_RQ_POURQUOI Coll_lments_de_Rponse
        Case RQ_QUI_EST_LA
            Traiter_RQ_QUI_EST_LA Coll_lments_de_Rponse
        Case RQ_QU_EST_CE
            Traiter_RQ_QU_EST_CE Coll_lments_de_Rponse
        Case RQ_STATUS
            Traiter_RQ_STATUS Coll_lments_de_Rponse
    End Select
End Sub

Public Sub Traiter_RQ_DEPLACEMENT(Coll_Rponses As Collection, obj_Requte As Cls_Requte)
    Const IDX_COMBIEN As Integer = 3
    Dim Rponse As String
    Dim Direction_demande As String
    
    Rponse = Coll_Rponses.Item(IDX_COMBIEN)
    If IsNumeric(Rponse) Then
        If CInt(Rponse) = 0 Then
            Beep
        End If
    End If
End Sub

Public Sub Traiter_RQ_JE_SUIS(Coll_Rponses As Collection)
    Const IDX_NOM As Integer = 3
    Const IDX_ID_DRESSEUR As Integer = 4
    
    Obj_Personnage.Nom = Coll_Rponses.Item(IDX_NOM)
    Obj_Personnage.IndexDresseur = Coll_Rponses.Item(IDX_ID_DRESSEUR)
    tablir_Position_Initiale
End Sub

Public Sub Traiter_RQ_LISTE_DRESSEURS(Coll_Rponses As Collection)
    Dim Str_Info As String
    
    Crer_la_Liste_des_Dresseurs Coll_Rponses
    Dlg_Choix_du_Dresseur.Show vbModal, Frm_POQespace
    Str_Info = Obj_Personnage.Surnom & RQ_SPARATEUR & Obj_Personnage.IndexDresseur
    Identifier_personnage Str_Info
End Sub

Public Sub Traiter_RQ_MAP_INFO(Coll_Rponses As Collection)
    Const IDX_NOM_RGION As Integer = 3
    Const IDX_DIRECTION As Integer = 8
    
    Frm_POQespace.Caption = Coll_Rponses.Item(IDX_NOM_RGION)
    Obj_Personnage.Direction = Coll_Rponses.Item(IDX_DIRECTION)
    Boussole_est_modife = True
    Vrifier_Environnement
End Sub

Public Sub Traiter_RQ_OU_SUIS_JE(Coll_Rponses As Collection)
    Crer_la_Liste_des_Zones Coll_Rponses
    Grille_Affiche_est_modifie = True
    Vrifier_Environnement
End Sub

Public Sub Traiter_RQ_POQ_INDEX(Coll_Rponses As Collection)
    Const IDX_POQMON As Integer = 3
    
    Frm_POQespace.Cmd_POQmons.Enabled = Coll_Rponses.Item(IDX_POQMON) <> 0
End Sub

Public Sub Traiter_RQ_POQ_INFO(Coll_Rponses As Collection)
End Sub

Public Sub Traiter_RQ_POURQUOI(Coll_Rponses As Collection)
End Sub

Public Sub Traiter_RQ_QUI_EST_LA(Coll_Rponses As Collection)
    Const MIN_COLL_RPONSES As Integer = 3
    
    Frm_POQespace.Cmd_Dresseurs.Enabled = Coll_Rponses.Count > MIN_COLL_RPONSES
End Sub

Public Sub Traiter_RQ_QU_EST_CE(Coll_Rponses As Collection)
    Const MIN_COLL_RPONSES As Integer = 2
    
    Frm_POQespace.Cmd_Objets.Enabled = Coll_Rponses.Count > MIN_COLL_RPONSES
End Sub

Public Sub Traiter_RQ_STATUS(Coll_Rponses As Collection)
End Sub


