#include "Carte.h"
#include "Position.h"
#include "OutilsGeneraux.h"
#include <fstream>
#include <iostream>
using namespace std;

bool EstDansCarte (const Position &p)
{
   return EstEntre (p.m_X, 0, LARGEUR_CARTE) && EstEntre (p.m_Y, 0, HAUTEUR_CARTE);
}

Case ObtenirCase (const Carte &c, const Position &p)
{
   Case temp = CreerCase (SYMBOLE_ILLEGAL);
   if (EstDansCarte (p))
   {
      temp = c.m_Cases[p.m_Y][p.m_X];
   }
   else
   {
      cerr << "Position { " << p.m_X << "," << p.m_Y << " } est illgale" << endl;
   }
   return temp;
}

Position VoisineEst   (const Position &p, const Carte &c)
{
   Position temp = POSITION_ILLEGALE;
   if (EstDansCarte (p))
   {
      temp = CreerPosition ((p.m_X + 1) % LARGEUR_CARTE, p.m_Y);
   }
   return temp;
}

Position VoisineNord  (const Position &p, const Carte &c)
{
   Position temp = POSITION_ILLEGALE;
   if (EstDansCarte (p))
   {
      if (p.m_Y == 0)
         temp = CreerPosition (p.m_X, HAUTEUR_CARTE - 1);
      else
         temp = CreerPosition (p.m_X, p.m_Y - 1);
   }
   return temp;
}

Position VoisineOuest (const Position &p, const Carte &c)
{
   Position temp = POSITION_ILLEGALE;
   if (EstDansCarte (p))
   {
      if (p.m_X == 0)
         temp = CreerPosition (LARGEUR_CARTE - 1, p.m_Y);
      else
         temp = CreerPosition (p.m_X - 1, p.m_Y);
   }
   return temp;
}

Position VoisineSud   (const Position &p, const Carte &c)
{
   Position temp = POSITION_ILLEGALE;
   if (EstDansCarte (p))
   {
      temp = CreerPosition (p.m_X, (p.m_Y + 1) % HAUTEUR_CARTE);
   }
   return temp;
}



char ProchainSymbole (ifstream &fich)
{
   char c;
   while (fich.get (c) && c == '\n');
   return c;
}

int CompterElements (const Carte &c, const Symbole_t Symbole)
{
   int CptElems = 0;
   for (int i = 0; i < HAUTEUR_CARTE; i++)
   {
      for (int j = 0; j < LARGEUR_CARTE; j++)
      {
         if (ObtenirCase (c, CreerPosition (j, i)).m_Symbole == Symbole)
         {
            CptElems++;
         }
      }
   }
   return CptElems;
}

int CompterGenerateursPacman (const Carte &c)
{
   return CompterElements (c, SYMBOLE_GENERATEUR_PACMAN);
}

int CompterGenerateursFantomes (const Carte &c)
{
   return CompterElements (c, SYMBOLE_GENERATEUR_FANTOME);
}


Position TrouverElement (const Carte &c, const Symbole_t Symbole)
{
   Position pos = POSITION_ILLEGALE;
   for (int i = 0; i < HAUTEUR_CARTE; i++)
   {
      for (int j = 0; j < LARGEUR_CARTE; j++)
      {
         if (ObtenirCase (c, CreerPosition (j, i)).m_Symbole == Symbole)
         {
            pos = CreerPosition (j, i);
         }
      }
   }
   return pos;
}

Position TrouverGenerateurPacman (const Carte &c)
{
   return TrouverElement (c, SYMBOLE_GENERATEUR_PACMAN);
}

Position TrouverGenerateurFantomes (const Carte &c)
{
   return TrouverElement (c, SYMBOLE_GENERATEUR_FANTOME);
}

void InitialiserCarte (Carte &c)
{
   int NbGenPac = CompterGenerateursPacman (c);
   if (NbGenPac == 1)
   {
      int NbGenFantomes = CompterGenerateursFantomes (c); 
      if (NbGenFantomes== 1)
      {
         Position GenPac = TrouverGenerateurPacman (c);
         c.m_Pac = CreerPacman (GenPac);
         c.m_Cases[GenPac.m_Y][GenPac.m_X].m_Symbole = SYMBOLE_VIDE;
      }
      else
      {
         cerr << "Nombre illgal de gnrateurs de fantmes. Attendu: 1; rel: "
              << NbGenPac
              << endl;
         exit (-1);
      }
   }
   else
   {
      cerr << "Nombre illgal de gnrateurs de Pacman. Attendu: 1; rel: "
           << NbGenPac
           << endl;
      exit (-1);
   }
}


Carte CreerCarte (const string &NomFichier)
{
   Carte c;
   c.m_Nom = NomFichier;
   c.m_EstValide = false;
   for (int i = 0; i < NB_FANTOMES; i++)
   {
      c.m_Fantomes[i] = CreerFantome (POSITION_ILLEGALE, NB_DIRECTIONS);
   }
   for (int i = 0; i < HAUTEUR_CARTE; i++)
   {
      for (int j = 0; j < LARGEUR_CARTE; j++)
      {
         c.m_Cases [i][j] = CreerCase (SYMBOLE_VIDE);
      }
   }
   ifstream fich (NomFichier.c_str ());
   if (fich)
   {
      fich >> noskipws;
      for (int CptLignes = 0; CptLignes < HAUTEUR_CARTE; CptLignes++)
      {
         for (int CptColonnes = 0; CptColonnes < LARGEUR_CARTE; CptColonnes++)
         {
            char Symbole;
            if (Symbole = ProchainSymbole (fich))
               c.m_Cases[CptLignes][CptColonnes] = CreerCase (Symbole);
         }
      }
      c.m_EstValide = true;
   }
   else
   {
      cerr << "Incapable d'ouvrir le fichier " << NomFichier << endl;
   }
   InitialiserCarte (c);
   return c;
}

void GererNaissanceFantome (Carte &c)
{
   int PremierNonGenere = NB_FANTOMES;
   for (int i = 0; i < NB_FANTOMES; i++)
   {
      if (PremierNonGenere == NB_FANTOMES &&
          EstIllegale (c.m_Fantomes[i].m_Pos))
      {
         PremierNonGenere = i;
      }
   }
   if (PremierNonGenere != NB_FANTOMES)
   {
      c.m_Fantomes[PremierNonGenere] =
         CreerFantome (TrouverGenerateurFantomes (c), rand () % NB_DIRECTIONS);
   }
   else
   {
      Position pos = TrouverGenerateurFantomes (c);
      c.m_Cases[pos.m_Y][pos.m_X].m_Symbole = SYMBOLE_VIDE;
   }
}

void ChoisirNouvelleDirection (Fantome &f)
{
   Direction_t dirAvant = f.m_Dir;
   do
   {
      PivoterFantome (f, rand () % NB_DIRECTIONS);
   }
   while (f.m_Dir == dirAvant);
}

void EssayerDeplacementVers (Carte &c, const Position &dest, Fantome &f)
{
   if (!EstInaccessible (ObtenirCase (c, dest)) && EstDansCarte (dest))
   {
      DeplacerFantome (f, dest);
   }
   else
   {
      ChoisirNouvelleDirection (f);
   }
}

void GererDeplacementFantome (Carte &c, Fantome &f)
{
   if (!EstIllegale (f.m_Pos))
   {
      if (SontPareilles (f.m_Pos, c.m_Pac.m_Pos))
         c.m_Pac.m_Vivant = false;

      Direction_t DirectionsProspectives[NB_DIRECTIONS];
      int NbDirectionsPossibles = 0;
      if (!EstInaccessible (ObtenirCase (c, VoisineEst (f.m_Pos, c))))
      {
         DirectionsProspectives[NbDirectionsPossibles] = DIRECTION_FANTOME_EST;
         NbDirectionsPossibles++;
      }
      if (!EstInaccessible (ObtenirCase (c, VoisineNord (f.m_Pos, c))))
      {
         DirectionsProspectives[NbDirectionsPossibles] = DIRECTION_FANTOME_NORD;
         NbDirectionsPossibles++;
      }
      if (!EstInaccessible (ObtenirCase (c, VoisineOuest (f.m_Pos, c))))
      {
         DirectionsProspectives[NbDirectionsPossibles] = DIRECTION_FANTOME_OUEST;
         NbDirectionsPossibles++;
      }
      if (!EstInaccessible (ObtenirCase (c, VoisineSud (f.m_Pos, c))))
      {
         DirectionsProspectives[NbDirectionsPossibles] = DIRECTION_FANTOME_SUD;
         NbDirectionsPossibles++;
      }
      Direction_t ProchaineDirection;
      ProchaineDirection = rand () % NbDirectionsPossibles;
      if (ProchaineDirection != f.m_Dir ||
         ProchaineDirection == (f.m_Dir + 2) % NB_DIRECTIONS)
      {
         ProchaineDirection = rand () % NbDirectionsPossibles;
         if (ProchaineDirection != f.m_Dir ||
            ProchaineDirection == (f.m_Dir + 2) % NB_DIRECTIONS)
         {
            ProchaineDirection = rand () % NB_DIRECTIONS;
         }
      }
      f.m_Dir = ProchaineDirection;

      Position pos = POSITION_ILLEGALE;
      switch (f.m_Dir)
      {
      case DIRECTION_FANTOME_EST:
         pos = VoisineEst (f.m_Pos, c);
         EssayerDeplacementVers (c, pos, f);
         break;
      case DIRECTION_FANTOME_NORD:
         pos = VoisineNord (f.m_Pos, c);
         EssayerDeplacementVers (c, pos, f);
         break;
      case DIRECTION_FANTOME_OUEST:
         pos = VoisineOuest (f.m_Pos, c);
         EssayerDeplacementVers (c, pos, f);
         break;
      case DIRECTION_FANTOME_SUD:
         pos = VoisineSud (f.m_Pos, c);
         EssayerDeplacementVers (c, pos, f);
         break;
      default:
         cerr << "Direction invalide pour un fantme: "
               << f.m_Dir
               << endl;
      }
   }
}

void GererDeplacementFantomes (Carte &c)
{
   for (int i = 0; i < NB_FANTOMES; i++)
   {
      GererDeplacementFantome (c, c.m_Fantomes[i]);
   }
}

void EssayerBoufferPacman (Carte &c)
{
   for (int i = 0; i < NB_FANTOMES; i++)
   {
      if (!EstIllegale (c.m_Fantomes[i].m_Pos))
      {
         if (SontPareilles (c.m_Fantomes[i].m_Pos, c.m_Pac.m_Pos))
            c.m_Pac.m_Vivant = false;
      }
   }
}

void GererFantomes (Carte &c)
{
   //
   // L'ordre est important...
   //
   EssayerBoufferPacman (c);
   GererDeplacementFantomes (c);
   EssayerBoufferPacman (c);
   GererNaissanceFantome (c);
}

bool EstPositionFantome (const Position &p, const Carte &c)
{
   bool Resultat = false;
   if (!EstIllegale (p))
   {
      for (int i = 0; i < NB_FANTOMES; i++)
      {
         if (SontPareilles (p, c.m_Fantomes[i].m_Pos))
            Resultat = true;
      }
   }
   return Resultat;
}

void Afficher (const Carte &c)
{
   system ("cls");
   for (int CptLignes = 0; CptLignes < HAUTEUR_CARTE; CptLignes++)
   {
      for (int CptColonnes = 0; CptColonnes < LARGEUR_CARTE; CptColonnes++)
      {
         Position p = CreerPosition (CptColonnes, CptLignes);
         if (SontPareilles (p, ObtenirPositionPacMan (c)))
            Afficher (CreerCase (SYMBOLE_PACMAN));
         else if (EstPositionFantome (p, c))
            Afficher (CreerCase (SYMBOLE_FANTOME));
         else
            Afficher (c.m_Cases[CptLignes][CptColonnes]);
      }
      cout << endl;
   }
}

void Gerer (Carte &c)
{
   if (c.m_EstValide)
   {
      Afficher (c);
      GererFantomes (c);
   }
   else
      cerr << "La carte " << c.m_Nom << " est invalide" << endl;
}


Position ObtenirPositionPacMan (const Carte &c)
{
   return c.m_Pac.m_Pos;
}

bool EstVoisine (const Position &p, const Position &autre, const Carte &c)
{
   return EstDansCarte (p) && EstDansCarte (autre) && 
          (SontPareilles (p, VoisineEst   (autre, c)) ||
           SontPareilles (p, VoisineNord  (autre, c)) ||
           SontPareilles (p, VoisineOuest (autre, c)) ||
           SontPareilles (p, VoisineSud   (autre, c)));
}

void Manger (Carte &c, const Position &p)
{
   c.m_Cases[p.m_Y][p.m_X].m_Symbole = SYMBOLE_VIDE;
   c.m_Pac.m_Points += POINTS_BOUFFE;
}

bool DeplacerPacMan (Carte &c, const Position &p)
{
   bool Resultat = false;
   if (EstVoisine (p, ObtenirPositionPacMan (c), c) &&
       !EstInaccessible (ObtenirCase (c, p)))
   {
      if (ContientBouffe (ObtenirCase (c, p)))
      {
         Manger (c, p);
         if (CompterElements (c, SYMBOLE_BOUFFE) == 0)
         {
            c.m_Pac.m_Victoire = true;
         }
      }
      c.m_Pac.m_Pos = p;
      Resultat = true;
   }
   return Resultat;
}

