#ifndef CARTE_H
#define CARTE_H

#include "Case.h"
#include "Position.h"
#include "Fantome.h"
#include "Pacman.h"
#include <string>
using namespace std;

const int LARGEUR_CARTE = 78,
          HAUTEUR_CARTE = 21;

const int NB_FANTOMES = 4;

const int POINTS_BOUFFE = 10;

struct Carte
{
   string m_Nom;
   bool m_EstValide;
   Case m_Cases[HAUTEUR_CARTE][LARGEUR_CARTE];
   Pacman m_Pac;
   Fantome m_Fantomes[NB_FANTOMES];
};

Carte CreerCarte (const string &NomFichier);
void Afficher (const Carte &c);
void Gerer (Carte &c);

Case ObtenirCase (const Carte &c, const Position &p);

Position VoisineEst   (const Position &p, const Carte &c);
Position VoisineNord  (const Position &p, const Carte &c);
Position VoisineOuest (const Position &p, const Carte &c);
Position VoisineSud   (const Position &p, const Carte &c);
bool EstVoisine (const Position &p, const Position &autre, const Carte &c);

Position ObtenirPositionPacMan (const Carte &c);
bool DeplacerPacMan (Carte &c, const Position &p);

#endif // !defined CARTE_H
