#ifndef ADRESSE_H
#define ADRESSE_H

#include "relation.h"
#include <string>
#include <iosfwd>

class Adresse
   : relation::ordonnancement<Adresse>, relation::equivalence<Adresse>
{
public:
   using elem_type = short;
   using str_type = std::string;
private:
   str_type texte_;
public:
   Adresse(elem_type, elem_type, elem_type, elem_type);
   template <class C, std::size_t N>
      Adresse(const C(&s)[N])
         : texte_(s)
      {
      }
   Adresse(const str_type &s)
      : texte_(s)
   {
   }
   Adresse(const Adresse &) = default;
   Adresse& operator=(const Adresse &) = default;
   Adresse(Adresse &&autre)
      : texte_(std::move(autre.texte_))
   {
   }
   Adresse& operator=(Adresse &&autre)
   {
      texte_ = std::move(autre.texte_);
      return *this;
   }
   str_type valeur() const
      { return texte_; }
   friend std::ostream &operator<<(std::ostream &os, const Adresse &addr)
      { return os << addr.valeur(); }
   bool operator==(const Adresse &addr) const
      { return valeur() == addr.valeur(); }
   bool operator < (const Adresse &addr) const
      { return valeur() < addr.valeur(); }
   static Adresse local();
};

#endif
