#ifndef DEPOT_H
#define DEPOT_H

#include "incopiable.h"
#include <map>
#include <algorithm>

template <class K, class V>
   class Depot
      : Incopiable
   {
   public:
      using key_type = K;
      using value_type = V;
      class Introuvable {};
   private:
      std::map<K, value_type> corresp_;
   protected:
      Depot() = default;
      void install(const key_type &k, const value_type &v)
      {
         corresp_[k] = v;
      }
   public:
      template <class T>
         static const T &get()
         {
            static T singleton;
            return singleton;
         }
      value_type trouver(key_type k) const
      {
         using std::end;
         auto itt = corresp_.find(k);
         if (itt == end(corresp_)) throw Introuvable{};
         return itt->second;
      }
   };

#endif
