#ifndef FAMILLES_PROTOCOLE_H
#define FAMILLES_PROTOCOLE_H

#include "depot.h"
#include <map>

//
// Abstractions
//
enum FamilleProtocole
{
   IpV4, Tcp, Udp, IpV6 // etc.
};

//
// Singleton de soutien
//
class GestionnaireProtocoles
   : public Depot<FamilleProtocole, int>
{
   friend class Depot<FamilleProtocole, int>;
   GestionnaireProtocoles();
public:
   static const GestionnaireProtocoles& get() 
   {
      return Depot<FamilleProtocole, int>::get<GestionnaireProtocoles>();
   }
};

#endif
