#include "Port.h"
#include <iostream>
using namespace std;
#if   defined(_WIN32)
#include <Winsock2.h>
#else // if defined(unix)
#include <netdb.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#endif

auto Port::normaliser(value_type val) -> value_type
{
   return htons(val);
}
auto Port::denormaliser(value_type val) -> value_type
{
   return ntohs(val);
}

istream &operator>>(istream &is, Port &p)
{
   if (!is) return is;
   Port::value_type val;
   if (is >> val) p = Port{val};
   return is;
}
ostream &operator<<(ostream &os, const Port &p)
{
   return os << p.valeur(Brute{});
}
