#ifndef PORT_H
#define PORT_H

#include "relation.h"
#include <iosfwd>

//
// Aiguillage statique
//
class Brute {};
class Normalisee {};
//
// Reprsentation
//
class Port
   : relation::equivalence<Port>, relation::ordonnancement<Port>
{
public:
   using value_type = unsigned short;
private:
   value_type valeur_;
public:
   // Prend une valeur brute (dnormalise)
   constexpr Port(value_type val = {})
      : valeur_{val}
   {
   }
   constexpr value_type valeur(Brute) const noexcept
   {
      return valeur_;
   }
   value_type valeur(Normalisee) const noexcept
   {
      return normaliser(valeur(Brute{}));
   }
   constexpr bool operator==(const Port &p) const noexcept
   {
      return valeur_ == p.valeur_; // valeur(Brute{}) == p.valeur(Brute{}); // does not constexpr with VS2014 CTP3... Why?
   }
   constexpr bool operator <(const Port &p) const noexcept
   {
      return valeur_ < p.valeur_; // valeur(Brute{}) < p.valeur(Brute{}); // does not constexpr with VS2014 CTP3... Why?
   }
   static value_type normaliser(value_type);
   static value_type denormaliser(value_type);
};

std::istream &operator>>(std::istream &, Port &);
std::ostream &operator<<(std::ostream &, const Port &);

#endif
