#include "socket_serveur.h"
#include "socket_client.h"
#include "socket_conversation.h"
#include "GestionnaireSockets.h"
#include "port.h"
#include <iostream>
#include <thread>
#include <atomic>
#include <string>
#include <algorithm>
#include <iterator>
#include <memory>
using namespace std;

int main()
{
   atomic<bool> fini = false;
   const Port PORT = 4444;
   thread serveur([&]() {
      socket_serveur srv{ PORT };
      auto conv = srv.accepter();
      thread reception([&]() {
         try
         {
            while (!fini)
            {
               char buf[1000];
               auto n = conv.recevoir(begin(buf), end(buf));
               copy(begin(buf), begin(buf) + n, ostream_iterator<char>{cout});
            }
         }
         catch (...)
         {
         }
      });
      reception.join();
   });
   {
      socket_client client{PORT, Adresse::local()};
      while (!fini)
      {
         string s;
         if (getline(cin, s))
         {
            s += '\n';
            auto n = client.envoyer(begin(s), end(s));
         }
         else
            fini = true;
      }
   }
   serveur.join();
}