#ifndef REPOSITORY_H
#define REPOSITORY_H

#include "incopiable.h"
#include "transition_algorithm.h"
#include <map>
#include <mutex>
#include <cassert>
#include <iterator>

template <class T>
   class Repository
   {
   public:
      using id_type = long;
   private:
      std::map<id_type,T> elems_;
      mutable std::mutex mutex_;
      id_type cur_;
      Repository()
         : cur_{}
      {
      }
   public:
      static Repository &get()
      {
         static Repository singleton;
         return singleton;
      }
      id_type add(const T &elem)
      {
         using namespace std;
         lock_guard<mutex> av{mutex_};
         elems_[cur_] = elem;
         return cur_++;
      }
      void remove(const id_type id)
      {
         using namespace std;
         lock_guard<mutex> av{mutex_};
         auto itt = elems_.find(id);
         assert(itt != end(elems_));
         elems_.erase(itt);
      }
      T elem(const id_type id) const
      {
         using namespace std;
         lock_guard<mutex> av{mutex_};
         auto itt = elems_.find(id);
         assert(itt != end(elems_));
         return itt->second;
      }
      template <class C>
         C elems() const
         {
            using namespace std;
            lock_guard<mutex> av{mutex_};
            C cont;
            transform(begin(elems_), end(elems_), back_inserter(cont), [&](const pair<id_type, T> &p) {
               return p.second;
            });
            return cont;
         }
   };

#endif
