#include "end_point.h"
#include "text_utils.h"
#include "Adresse.h"
#include "port.h"
#include "lexical_cast.h"
#include "transition_algorithm.h"
#include <vector>
#include <string>
#include <cassert>
#include <ostream>
using namespace std;

end_point end_point::from(const string &s)
{
   using pv_type = port_type::value_type;
   auto v = split(s, SEP);
   if (v.empty() || v.size() > 2)
      throw not_well_formed{};
   transform(begin(v), end(v), begin(v), [](string s) { return trim(move(s)); });
   return v.size() == 2? end_point{address_type(v[0]), lexical_cast<pv_type>(v[1])} :
                         end_point{Adresse::local(),lexical_cast<pv_type>(v[0])};
}

ostream &operator<<(ostream &os, const end_point &ep)
{
   return os << ep.address() << end_point::SEP << ep.port().valeur(Brute{});
}
