#ifndef END_POINT_H
#define END_POINT_H

#include "Port.h"
#include "Adresse.h"
#include "relation.h"
#include <iosfwd>
#include <string>

class end_point
   : relation::equivalence<end_point>, relation::ordonnancement<end_point>
{
public:
   using port_type = Port;
   using address_type = Adresse;
   class not_well_formed {};
private:
   port_type port_;
   address_type address_;
   static constexpr char SEP = ':';
public:
   end_point()
      : address_{Adresse::local()}
   {
   }
   end_point(const address_type &address, const port_type &port)
      : address_(address), port_{port}
   {
   }
   address_type address() const
      { return address_; }
   port_type port() const
      { return port_; }
   friend std::ostream &operator<<(std::ostream &, const end_point &);
   static end_point from(const std::string &);
   bool operator==(const end_point &ep) const
      { return port() == ep.port() && address() == ep.address(); }
   bool operator<(const end_point &ep) const
      { return address() < ep.address() || (address() == ep.address() && port() < ep.port()); }
};

#endif
