#ifndef EXECUTION_TIME_H
#define EXECUTION_TIME_H

#include "Temps.h"
#include "relation.h"
#include <chrono>

using moment = std::chrono::system_clock::time_point;
using duree = std::chrono::system_clock::duration;

Temps<Milliseconde> to_milliseconde(duree);

inline moment maintenant()
   { return std::chrono::system_clock::now(); }
inline double duree_brute(duree d)
   { return static_cast<double>(d.count()); }

template <class F>
   duree minuter(F f)
   {
      auto avant = maintenant();
      f();
      return maintenant() - avant;
   }

#endif
