#ifndef FUNC_COMPOSITION_H
#define FUNC_COMPOSITION_H

template <class F, class G>
   class f_g_x_impl
   {
      F f_;
      G g_;
   public:
      constexpr f_g_x_impl(F f, G g)
         : f_{f}, g_{g}
      {
      }
      template <class Arg>
         auto operator()(Arg arg) -> decltype(f_(g_(arg)))
         {
            return f_(g_(arg));
         }
   };

template <class F, class G>
   f_g_x_impl<F,G> f_g_x(F f, G g)
      { return f_g_x_impl<F,G>{f,g}; }

template <class F, class G>
   class f_or_g_x_impl
   {
      F f_;
      G g_;
   public:
      f_or_g_x_impl(F f, G g)
         : f_{f}, g_{g}
      {
      }
      template <class Arg>
         auto operator()(Arg arg) -> decltype(f_(arg) || g_(arg))
         {
            return f_(arg) || g_(arg);
         }
   };

template <class F, class G>
   f_or_g_x_impl<F,G> f_or_g_x(F f, G g)
      { return f_or_g_x_impl<F,G>{f,g}; }

template <class F, class G>
   class f_and_g_x_impl
   {
      F f_;
      G g_;
   public:
      f_and_g_x_impl(F f, G g)
         : f_{f}, g_{g}
      {
      }
      template <class Arg>
         auto operator()(Arg arg) -> decltype(f_(arg) && g_(arg))
         {
            return f_(arg) && g_(arg);
         }
   };

template <class F, class G>
   f_and_g_x_impl<F,G> f_and_g_x(F f, G g)
      { return f_and_g_x_impl<F,G>{f,g}; }

template <class F>
   class not_f_x_impl
   {
      F f_;
   public:
      not_f_x_impl(F f)
         : f_{f}
      {
      }
      template <class Arg>
         auto operator()(Arg arg) -> decltype(!f_(arg))
         {
            return !f_(arg);
         }
   };

template <class F>
   not_f_x_impl<F> not_f_x(F f)
      { return not_f_x_impl<F>{f}; }

#endif

