#ifndef LEXICAL_CAST_H
#define LEXICAL_CAST_H

#include <type_traits>
#include <cstdlib>
#include <string>

class implicite   {};
class texte_dest  {};
class texte_texte {};
class general     {};

template <class T>
   struct est_texte
      : std::integral_constant<bool, false>
   {
   };
template <class C>
   struct est_texte<std::basic_string<C>>
      : std::integral_constant<bool, true>
   {
   };

template <class D, class S>
   struct traits_conversion
   {
      using type = typename std::conditional <
         std::is_same<D,S>::value || std::is_convertible<S, D>::value,
         implicite,
         typename std::conditional <
            est_texte<D>::value,
            typename std::conditional <
               est_texte<S>::value,
               texte_texte,
               texte_dest
            >::type,
            general
         >::type
      >::type;
   };

#include <sstream>

class bad_lexical_cast {};

template <class D, class S>
   D lexical_cast(S &&src, general)
   {
      std::stringstream sstr;
      sstr << src;
      D dest;
      if (!(sstr >> dest))
         throw bad_lexical_cast{};
      return dest;
   }
template <class D, class S>
   D lexical_cast(S &&src, texte_dest)
   {
      using value_type = typename D::value_type;
      std::basic_stringstream<value_type> sstr;
      sstr << src;
      return sstr.str();
   }
template <class D, class S>
   D lexical_cast(S &&src, texte_texte)
      { return D{src.begin(), src.end()}; }
template <class D, class S>
   D lexical_cast(S &&src, implicite)
   { 
      return src;
   }

//template <class T, class U>
//   void diag (std::ostream &os)
//   {
//      using std::endl;
//      os << typeid(T).name () << " <-- \n\t" << typeid(U).name () << endl;
//      os << "\tMeme type? " << meme_type<T,U>::value << endl;
//      os << "\t" << typeid(traits_conversion<T, U>::type()).name() << endl;
//   }

template <class D, class S>
   D lexical_cast(S &&src)
   {
      //diag<D, S>(std::cout);
      return lexical_cast<D>(
         std::forward<S>(src),
         typename traits_conversion<typename std::remove_cv<D>::type,
         typename std::remove_cv<S>::type>::type{}
      );
   }

#endif

