#ifndef LOCAL_BUFFER_H
#define LOCAL_BUFFER_H

#include "transition_algorithm.h"
#include <vector>
#include <cstdlib>
#include <cassert>
#include <array>
#include <type_traits>

//
// Note: efficient with C++11 due to rvalue references
//
template <class T, std::size_t N, std::size_t STATIC_N_BOUNDARY = 1024 * 8>
   struct local_buffer
   {
   private:
      enum { STATIC_ALLOC = (N <= STATIC_N_BOUNDARY) };
      using std_array_type = typename std::array<T, N>;
   public:
      using implementation_type = typename
         std::conditional<
            STATIC_ALLOC, std_array_type, std::vector<T>
         >::type;
      using efficient_sequence_constructed_implementation_type = std::vector<T>;
   private:
      class array_type {};
      class vector_type {};
      using selector_type = typename
         std::conditional<
            STATIC_ALLOC, array_type, vector_type
         >::type;
      static implementation_type create(array_type)
         { return implementation_type{}; }
      static implementation_type create(vector_type)
         { return implementation_type{N,T{}}; }
      template <class Itt>
         static implementation_type create(vector_type, Itt debut, Itt fin)
         {
            using std::distance;
            assert(distance(debut, fin) <= N);
            return implementation_type{debut, fin};
         }
   public:
      static implementation_type create()
         { return create(selector_type{}); }
      template <class Itt>
         static efficient_sequence_constructed_implementation_type create(Itt debut, Itt fin)
         {
            using std::distance;
            assert(distance(debut, fin) <= N);
            return efficient_sequence_constructed_implementation_type{debut, fin};
         }
   };

#endif
