#ifndef LOCALE_EXTENSION_H
#define LOCALE_EXTENSION_H

#include "transition_algorithm.h"
#include <type_traits>
#include <locale>
#include <string>
#include <iterator>

//
// ICI: acclrer en implmentant le code sur les abstractions  l'aide des
// primitifs (l, on fait le contraire)
//

inline static const std::locale& chosen_locale()
{
   static const std::locale LOC = std::locale{""};
   return LOC;
}

template <class D>
   auto widening_facet(const std::locale &loc) -> decltype(std::use_facet<std::ctype<D>>(loc))
      { return std::use_facet<std::ctype<D>>(loc); }

template <class D, class S>
   D widen_char(S && src, const std::locale &loc)
      { return widening_facet<D>(loc).widen(std::forward<S>(src)); }
template <class D, class S>
   D widen_char(S &&src)
      { return widen_char<D>(std::forward<S>(src), chosen_locale()); }
template <class D, class S>
   std::basic_string<D> widen_string(const std::basic_string<S> &src, const std::locale &loc)
   {
      using namespace std;
      basic_string<D> dest;
      dest.reserve(src.size() + 1);
      const auto &f = widening_facet<D>(loc);
      transform(begin(src), end(src), back_inserter(dest), [&](const S c) {
         return f.widen(c);
      });
      return dest;
   }
template <class D, class S>
   std::basic_string<D> widen_string(const std::basic_string<S> &src)
      { return widen_string<D>(src, chosen_locale()); }
template <class D, class S>
   std::basic_string<D> widen_string(std::basic_string<S> &&src)
      { return widen_string<D>(std::move(src), chosen_locale()); }
template <class D, class S>
   std::basic_string<D> widen_string (const S *src, const std::locale &loc)
      { return widen_string<D>(std::basic_string<S>(src), loc); }
template <class D, class S>
   std::basic_string<D> widen_string (const S *src)
      { return widen_string<D>(src, chosen_locale()); }

#endif
