#ifndef LOG_H
#define LOG_H

//#ifdef MODE_STANDALONE
#include <iostream>
template <class T>
   void print_log_(T && arg)
   {
      std::clog << arg << std::flush;
   }
template <class T, class ... Args>
   void print_log_(T && arg, Args && ... args)
   {
      print_log_(std::forward<T>(arg));
      print_log_(std::forward<Args>(args)...);
   }
template <class ... Args>
   void print_log(Args && ... args)
   {
      print_log_(std::forward<Args>(args)..., '\n');
   }
//#else
//#include "lexical_cast.h"
//#include <string>
//#include <android/log.h>
//template <class T>
//   void print_log(T && arg)
//   {
//      auto s = lexical_cast<std::string>(arg);
//      __android_log_print(ANDROID_LOG_INFO, "HOST_ERROR", "%s", s.c_str());
//   }
//template <class T>
//   std::string logger_stringify(T && arg)
//   {
//      return lexical_cast<std::string>(std::forward<T>(arg));
//   }
//template <class T, class ... Args>
//   std::string logger_stringify(T && arg, Args && ... args)
//   {
//      return lexical_cast<std::string>(std::forward<T>(arg)) + logger_stringify(std::forward<Args>(args)...);
//   }
//template <class ... Args>
//   void print_log(Args && ... args)
//   {
//      print_log(logger_stringify(std::forward<Args>(args)...));
//   }
//#endif



#endif
