#ifndef LOW_LEVEL_SOCKET_LAYER_H
#define LOW_LEVEL_SOCKET_LAYER_H

#include "FamillesAdresse.h"
#include "FamillesProtocole.h"
class Port;
class Adresse;

struct low_level_layer
{
#if   defined(_WIN32)
   using socket_t = unsigned int __w64;
#else // if defined(unix)
   using socket_t = int;
#endif
   typedef int erreur_type;
   static socket_t invalid_socket() noexcept;
   static bool is_invalid(socket_t) noexcept;
   static bool is_error(int code) noexcept;
   static int last_error() noexcept;
   static void conclure(socket_t) noexcept;
   static void fermer(socket_t) noexcept;
   static void rendre_bloquant(socket_t) noexcept;
   static void rendre_non_bloquant(socket_t) noexcept;
   static socket_t accepter(socket_t srv, Port &, Adresse &);
   static socket_t creer(FamilleAdresse, FamilleProtocole);
   static void lier(socket_t, const Port&, FamilleAdresse);
   static void connecter(socket_t, const Port&, FamilleAdresse, const Adresse&);
   static bool ok_if_nonblocking(erreur_type);
   static int send(socket_t, const char *, int, int);
   static int recv(socket_t, char *, int, int);
};

#endif
