#ifndef MATHS_EXT_H
#define MATHS_EXT_H

#include <type_traits>
#include <limits>
#include <cmath>

namespace maths_ext
{
   static constexpr double PI = 3.14159265358979323846;
   template <class>
      struct numeric_limits_ext;
   template <>
      struct numeric_limits_ext<float>
      {
         static constexpr float seuil_assez_proche()
            { return 0.000001f; } // mettons
      };
   template <>
      struct numeric_limits_ext<double>
      {
         static constexpr double seuil_assez_proche()
            { return 0.0000000001; } // mettons
      };
   template <>
      struct numeric_limits_ext<long double>
      {
         static constexpr long double seuil_assez_proche()
            { return 0.000000000000001L; } // mettons
      };

   class exact_representation
   {
      constexpr exact_representation() = default;
   };
   class float_representation
   {
      constexpr float_representation() = default;
   };

   template <class T>
      struct precision_traits
      {
         using representation_type = typename
            std::conditional<
               std::numeric_limits<T>::is_exact,
               exact_representation,
               float_representation
            >::type;
         // static constexpr representation_type rep()
         //   { return {}; } // not legal yet
      };

   template <class T>
      constexpr T absolute_value(T a)
         { return a < 0? -a : a; }
   template <class T>
      constexpr bool assez_proches(T a, T b, exact_representation)
         { return a == b; }
   template <class T>
      /*constexpr*/ bool assez_proches(T a, T b, float_representation)
         { return absolute_value(a - b) <= numeric_limits_ext<T>::seuil_assez_proche(); }
   template <class T>
      using precision_representation_t = typename precision_traits<T>::representation_type;
   template <class T>
      /*constexpr*/ bool assez_proches(T a, T b)
      {
         return assez_proches(
            a, b, precision_representation_t<T>{}
         );
      }
}

#endif
