#ifndef NOT_WELL_FORMED_H
#define NOT_WELL_FORMED_H

#include <string>

template <class C>
   struct not_well_formed_impl
   {
      using str_type = std::basic_string<C>;
      const str_type tentative_context;
      not_well_formed_impl(const str_type &s = {})
         : tentative_context(s)
      {
      }
   };
template <class C>
   not_well_formed_impl<C> not_well_formed(const std::basic_string<C> &s)
   {
      return not_well_formed_impl<C>{s};
   }
template <class C>
   not_well_formed_impl<C> not_well_formed(const C *s)
   {
      return not_well_formed_impl<C>{s};
   }
template <class C, std::size_t N>
   not_well_formed_impl<C> not_well_formed(const C (&s)[N])
   {
      using std::begin;
      using std::end;
      using str_type = typename
         not_well_formed_impl<C>::str_type;
      return not_well_formed_impl<C>{str_type{begin(s), end(s)}};
   }
inline not_well_formed_impl<char> not_well_formed()
{
   return not_well_formed_impl<char>{};
}

#endif
