#ifndef REFERENT_TRAITS_H
#define REFERENT_TRAITS_H

//
// ICI: standardiser les traits de rfrents
// (s'inspirer d'iterator_traits et de std::iterator, sans doute)
//

#include "locale_extension.h"
#include <string>

struct base_referent_traits
{
protected:
   template <class C, class S>
      static std::basic_string<C> creer_nom(const std::basic_string<S> &s)
         { return widen_string<C>(s); }
   template <class C, class S>
      static std::basic_string<C> creer_nom(const S *s)
         { return creer_nom<C>(std::basic_string<S>{s}); }
};

template <class R>
   struct referent_traits;

//
// Expected:
//
// probably inherit publicly or protectedly from base_referent_traits
//
// define value_type type
// static value_type default_value()
//   { return default_value_for_R
//template <class C>
//   static std::basic_string<C> nom()
//      { return creer_nom<C>("name_in_standard_unit"); }
//static value_type to_neutral(const value_type)
//   { return conversion_to_neutral_format }
//static value_type from_neutral(const value_type)
//   { return conversion_from_neutral_format }
//

template <class D, class S>
   typename referent_traits<D>::value_type
      referent_cast(typename referent_traits<S>::value_type val)
   {
      return referent_traits<D>::from_neutral(referent_traits<S>::to_neutral(val));
   }

#endif
