#ifndef SOCKETCLIENT_H
#define SOCKETCLIENT_H

#include "FamillesAdresse.h"
#include "FamillesProtocole.h"
#include "Port.h"
#include "Adresse.h"
#include "incopiable.h"
#include "local_buffer.h"
#include <memory>

class end_point;
class socket_conversation;

class socket_client
   : Incopiable
{
   class Impl;
   using ptr_type = std::unique_ptr<Impl>;
   ptr_type impl;
public:
   socket_conversation extract_representation();
   socket_client(socket_client &&);
   socket_client(const Port&, const Adresse&);
   ~socket_client();
   template <class Itt>
      int envoyer(Itt debut, Itt fin)
      {
         const std::size_t NELEMS_TAMPON_DEFAUT = 1024 * 8;
         return envoyer<NELEMS_TAMPON_DEFAUT>(debut, fin);
      }
   template <std::size_t NELEMS_MAX, class Itt>
      int envoyer(Itt debut, Itt fin)
      {
         using namespace std;
         using elem_type = typename
            iterator_traits<Itt>::value_type;
         using buffer_selector = local_buffer<elem_type, NELEMS_MAX>;
         const auto NELEMS =
            min<size_t>(distance(debut, fin), NELEMS_MAX);
         auto tampon = buffer_selector::create(debut, debut + NELEMS);
         return envoyerPrimitif(
            reinterpret_cast<const char*>(&tampon[0]),
            static_cast<int>(NELEMS*sizeof(elem_type))
         );
      }
   int envoyerPrimitif(const char *seq, int n);
   template <class Itt>
      int recevoir(Itt debut, Itt fin)
      {
         const std::size_t NELEMS_TAMPON_DEFAUT = 1024 * 8;
         return recevoir<NELEMS_TAMPON_DEFAUT>(debut, fin);
      }
   template <std::size_t NELEMS_MAX, class Itt>
      int recevoir(Itt debut, Itt fin)
      {
         using namespace std;
         using elem_type = typename
            iterator_traits<Itt>::value_type;
         using buffer_selector = local_buffer<elem_type, NELEMS_MAX>;
         auto tampon = buffer_selector::create();
         const auto NELEMS =
            min<size_t>(distance(debut, fin), NELEMS_MAX);
         const auto NRECUS =
            recevoirPrimitif(reinterpret_cast<char*>(&tampon[0]), NELEMS*sizeof(elem_type));
         if (NRECUS > 0)
            copy(&tampon[0], &tampon[NRECUS], debut);
         return NRECUS;
      }
   int recevoirPrimitif(char *, std::size_t);
   bool est_bloquant() const;
   void rendre_bloquant();
   void rendre_non_bloquant();
   end_point endpoint() const;
};

#endif
