#ifndef SOCKET_CONVERSATION_H
#define SOCKET_CONVERSATION_H

#include "local_buffer.h"
#include "incopiable.h"
#include "low_level_socket_layer.h"
#include <memory>

class end_point;

class socket_conversation
   : Incopiable
{
   class Impl;
   using ptr_type = std::unique_ptr<Impl>;
   ptr_type impl;
public:
   using socket_t = low_level_layer::socket_t;
   socket_conversation(socket_t, const Port&, const Adresse&);
   socket_conversation(socket_conversation &&);
   ~socket_conversation();
   template <class Itt>
      int envoyer(Itt debut, Itt fin)
      {
         const std::size_t NELEMS_TAMPON_DEFAUT = 1024 * 8;
         return envoyer<NELEMS_TAMPON_DEFAUT>(debut, fin);
      }
   template <std::size_t NELEMS_MAX, class Itt>
      int envoyer(Itt debut, Itt fin)
      {
         using namespace std;
         using elem_type = typename
            iterator_traits<Itt>::value_type;
         using buffer_selector = local_buffer<elem_type, NELEMS_MAX>;
         const auto NELEMS =
            min<size_t>(distance(debut, fin), NELEMS_MAX);
         auto tampon = buffer_selector::create(debut, debut + NELEMS);
         return envoyerPrimitif(
            reinterpret_cast<const char*>(&tampon[0]),
            static_cast<int>(NELEMS*sizeof(elem_type))
         );
      }
   int envoyerPrimitif(const char *seq, int n);
   template <class Itt>
      int recevoir(Itt debut, Itt fin)
      {
         const std::size_t NELEMS_TAMPON_DEFAUT = 1024 * 8;
         return recevoir<NELEMS_TAMPON_DEFAUT>(debut, fin);
      }
   template <std::size_t NELEMS_MAX, class Itt>
      int recevoir(Itt debut, Itt fin)
      {
         using namespace std;
         using elem_type = typename
            iterator_traits<Itt>::value_type;
         using buffer_selector = local_buffer<elem_type, NELEMS_MAX>;
         auto tampon = buffer_selector::create();
         const auto NELEMS = min<size_t>(distance(debut, fin), NELEMS_MAX);
         const int NRECUS =
            recevoirPrimitif(reinterpret_cast<char*>(&tampon[0]), NELEMS*sizeof(elem_type));
         if (NRECUS > 0)
            copy(&tampon[0], &tampon[NRECUS], debut);
         return NRECUS;
      }
   int recevoirPrimitif(char *, std::size_t);
   bool est_bloquant() const;
   void rendre_bloquant();
   void rendre_non_bloquant();
   end_point endpoint() const;
   void fermer();
};

#endif
