#ifndef SOCKET_ERRORS_H
#define SOCKET_ERRORS_H

#include "low_level_socket_layer.h"

bool ok_if_nonblocking(low_level_layer::erreur_type);

//
//
//
struct socket_exception
{
   using erreur_type = low_level_layer::erreur_type;
   const erreur_type erreur;
   constexpr socket_exception(erreur_type err)
      : erreur{err}
   {
   }
};

class no_end_point
{
};

class fermeture_homologue
   : public socket_exception
{
   bool propre_;
public:
   constexpr fermeture_homologue(erreur_type err, bool propre)
      : socket_exception{err}, propre_{propre}
   {
   }
   bool propre() const
      { return propre_; }
   bool brutale() const
      { return !propre(); }
};

struct erreur_acceptation
   : socket_exception
{
   constexpr erreur_acceptation(erreur_type err)
      : socket_exception{err}
   {
   }
};

struct erreur_creation
   : socket_exception
{
   constexpr erreur_creation(erreur_type err)
      : socket_exception{err}
   {
   }
};

struct erreur_liaison
   : socket_exception
{
   constexpr erreur_liaison(erreur_type err)
      : socket_exception{err}
   {
   }
};

struct erreur_connexion
   : socket_exception
{
   constexpr erreur_connexion(erreur_type err)
      : socket_exception{err}
   {
   }
};

#endif
