#include "socket_serveur.h"
#include "socket_conversation.h"
#include "low_level_socket_layer.h"
#include "socket_errors.h"
#include "log.h"
#include <cstdlib>
#include <atomic>
using namespace std;

class socket_serveur::Impl
{
public:
   using socket_t = low_level_layer::socket_t;
private:
   socket_t socket_;
   atomic<bool> bloquant_;
   Port port_;
public:
   Impl(const Port &port, FamilleAdresse fadr, FamilleProtocole fpro)
      : socket_{low_level_layer::creer(fadr, fpro)}, bloquant_{true}, port_{port}
   {
      try
      {
         low_level_layer::lier(socket_, port, fadr);
      }
      catch (...)
      {
         low_level_layer::fermer(socket_);
         throw;
      }
   }
   ~Impl()
   {
      low_level_layer::fermer(socket_);
   }
   bool est_bloquant() const
   {
      return bloquant_;
   }
   //
   // ICI: synchroniser?
   //
   void rendre_bloquant()
   {
      low_level_layer::rendre_bloquant(socket_);
      bloquant_ = true;
   }
   void rendre_non_bloquant()
   {
      low_level_layer::rendre_non_bloquant(socket_);
      bloquant_ = false;
   }
   low_level_layer::socket_t accepter(Port &port, Adresse &adresse)
   {
      return low_level_layer::accepter(socket_, port, adresse);
   }
   Port port() const
   {
      return port_;
   }
};

bool socket_serveur::est_bloquant() const
   { return impl->est_bloquant(); }
void socket_serveur::rendre_bloquant()
   { impl->rendre_bloquant(); }
void socket_serveur::rendre_non_bloquant()
   { impl->rendre_non_bloquant(); }


socket_serveur::socket_serveur(socket_serveur && original)
   : impl{move(original.impl)}
{
}

socket_serveur::socket_serveur(const Port &port)
   : impl{new Impl{port, FamilleAdresse::Inet, FamilleProtocole::Tcp}}
{
}

socket_serveur::socket_serveur(const Port &port, FamilleAdresse fadr, FamilleProtocole fpro)
   : impl{new Impl{port, fadr, fpro}}
{
}

socket_serveur::~socket_serveur() = default;

socket_conversation socket_serveur::accepter()
{
   Port port;
   auto adresse = Adresse::local();
   auto sck = impl->accepter(port, adresse);
   return socket_conversation{move(sck), port, adresse};
}

Port socket_serveur::port() const
   { return impl->port(); }
