// Fichier ILotto.h
// Par Patrice Roy, chic prof, 19 mars 2003
// Modifi le 13 novembre 2004
// Dclare l'interface ILotto et la classe SingletonGenerateurLotto
// NE PAS MODIFIER!!!!!

#ifndef ICOMBINAISON_H
#define ICOMBINAISON_H

#include <vector>
#include <string>

// Classe ILotto
// --> interface (classe purement abstraite)
//
// Tout driv de ILotto devra implanter au moins l'ensemble des
// mthodes abstraites de ILotto s'il est vou  tre instanci.
//
// L'interface ILotto reprsente les oprations possibles sur un
// objet reprsentant une loterie. Elle est opaque -- on ne voit
// pas son implmentation du tout.
//
// Note:   si une instance drive de ILotto alloue dynamiquement
//         des ressources (comme de la mmoire, via new), prenez
//         soin de bien librer ces ressources dans son destructeur!
class ILotto
{
public:
   // Mthode GetNom(), const
   // Intrants: aucun
   // Extrants: le nom de la lotto (ex: "6/49")
   // Rle:     permet de connatre le nom de la lotto 
   virtual std::string GetNom () const = 0;

   // Mthode GetValMinTirage (), const
   // Intrants: aucun
   // Extrants: la valeur minimum pour un tirage de la lotto
   // Rle:     permet de connatre la valeur minimum pour un
   //           tirage de la lotto. Ex: dans la lotto 6/49,
   //           toute valeur tire se trouve entre 1 et 49
   //           inclusivement. La valeur minimum est donc 1.
   virtual int GetValMinTirage () const = 0; // ex: 1

   // Mthode GetValMaxTirage (), const
   // Intrants: aucun
   // Extrants: la valeur maximum pour un tirage de la lotto
   // Rle:     permet de connatre la valeur maximum pour un
   //           tirage de la lotto. Ex: dans la lotto 6/49,
   //           toute valeur tire se trouve entre 1 et 49
   //           inclusivement. La valeur maximum est donc 49.
   virtual int GetValMaxTirage () const = 0; // ex: 49

   // Mthode GetNbValTirage (), const
   // Intrants: aucun
   // Extrants: le nombre de valeurs tires lors d'un tirage
   //           pour cette lotto
   // Rle:     permet de connatre le nombre de valeurs tires
   //           lors d'un tirage pour cette lotto. Ex: dans la
   //           lotto 6/49, on tire 6 valeurs par tirage.
   virtual int GetNbValTirage () const = 0;  // ex: 6

   // Mthode AccepterValeursRedondantes (), const
   // Intrants: aucun
   // Extrants: vrai si la lotto accepte les valeurs redondantes,
   //           faux sinon.
   // Rle:     permet de savoir si la lotto accepte les valeurs
   //           redondantes, donc la possibilit pour un tirage
   //           de voir apparatre plus d'une fois la mme valeur.
   virtual bool AccepterValeursRedondantes () const = 0;

   // Mthode Tirage ()
   // Intrants: aucun
   // Extrants: aucun
   // Rle:     effectue le tirage. L'instance est responsable de
   //           se souvenir des valeurs tires.
   virtual void Tirage () = 0;

   // Mthode GetTirage (), const
   // Intrants: aucun
   // Extrants: les valeurs obtenues lors du plus rcent tirage.
   // Rle:     permet de savoir les valeurs obtenues lors du plus
   //           rcent tirage.
   virtual std::vector<int> GetTirage () const = 0;

   // Mthode GetMontantTirage (), const
   // Intrants: aucun
   // Extrants: le montant  gagner.
   // Rle:     permet de savoir le montant  gagner.
   virtual int GetMontantTirage () const = 0;

   // Mthode GagneUnMontant (), const
   // Intrants: une combinaison de valeurs (un billet!)
   // Extrants: vrai si la combinaison remporte un montant, quel
   //           qu'il soit, et faux sinon
   // Rle:     permet de savoir si une combinaison est gagnante
   //           (en fonction du plus rcent tirage effectu).
   virtual bool GagneUnMontant (const std::vector<int> &) const = 0;

   // Mthode GetGains ()
   // Intrants: une combinaison de valeurs (un billet!)
   // Extrants: le montant remport avec cette combinaison (>=0)
   // Rle:     permet de savoir combien une conbinaison a remport
   //           (en fonction du plus rcent tirage effectu).
   //
   // Note:     si une combinaison gagne le gros lot, vous pouvez en
   //           tenir compte pour ajuster le gros lot  la baisse
   //           lors du prochain tirage.
   virtual int GetGains (const std::vector<int> &) = 0;

   // Mthode GetOrdreTirageImporte()
   // Intrants: aucun
   // Extrants: vrai si l'ordre des numros tirs importe, faux sinon
   // Rle:     permet de savoir si l'ordre importe dans les combinaisons
   //           d'une lotto donne (vrai pour la quotidienne, faux pour
   //          la 6/49, par exemple)
   virtual bool GetOrdreTirageImporte() const = 0;

   // Destructeur (vou  tre surcharg)
   virtual ~ILotto () {}
};


// Classe SingletonGenerateurLotto
// --> singleton (classe  instanciation unique)
//
// Une instance de SingletonGenerateurLotto sert  gnrer
// un vecteur de pointeurs  des drivs de ILotto, pour
// permettre au reste du systme d'utiliser les loteries sans
// avoir  les connatre.
//
//
// Note:   il est hautement probable que votre instance de
//         SingletonGenerateurLotto alloue dynamiquement des
//         ressources (comme de la mmoire, via new), en
//         particulier pour crer les loteries elles-mmes.
//         Prenez soin de bien librer ces ressources dans son
//         destructeur!
class SingletonGenerateurLotto
{
   // Attribut de classe LeGenerateur (le singleton  proprement dit)
   // Priv; il n'est accessible qu' travers la mthode de classe
   // GetInstance () -- voir plus bas.
   //
   // Note:   n'oubliez pas de le dclarer dans un fichier source!
   static SingletonGenerateurLotto LeGenerateur;

   // Constructeur.
   // Priv. Ne peut tre appel par programmation. Seul le singleton
   // sera construit, parce qu'il est lui-mme un membre de la classe
   // SingletonGenerateurLotto.
   SingletonGenerateurLotto ();

   // Attribut d'instance, priv.
   // Le vecteur m_Loteries contiendra un pointeur vers une instance
   // de chaque type de loterie gnr par l'instance propritaire.
   std::vector<ILotto *> m_Loteries;
public:

   // Mthode de classe, publique.
   // Donne accs (indirectement, par adresse) au singleton.
   static SingletonGenerateurLotto *GetInstance ()
   {
      return &LeGenerateur;
   }

   // Mthode d'instance.
   // Retourne une copie du vecteur de loteries.
   std::vector<ILotto *> GetLoteries ()
   {
      return m_Loteries;
   }

   // Mthode d'instance.
   // Trouve en retourne un pointeur vers la loterie portant
   // le nom reu en paramtre. Retourne 0 si ce nom n'est
   // pas le nom d'une des loteries supportes.
   ILotto *TrouverLotto (const std::string &Nom);

   // Destructeur.
   ~SingletonGenerateurLotto ();
};

#endif // !defined ICOMBINAISON_H
